#pragma pagelength ( 60 )
#pragma pagewidth ( 132 )
#pragma optimize(5,SPEED)
#pragma debug
#pragma code
#pragma objectextend

#include "reg51.h"
#include "decrypt.h"
#include "protype.h"


extern unsigned char code ext_ee[];
extern unsigned char indata[0x20];
extern unsigned char outdata[0x08];

unsigned char oi;

/***********************************/
void kernel_b( unsigned char in )
/***********************************/
{

  unsigned char a, b, c, d, i;
  unsigned int m;


  if ( indata[0]&8 == 0 ) return;   /* speed up */

    a = in;
    for (i = 0; i <= 4; i += 2)
    {
      b = outdata[i] & 0x3f;
      if (indata[1] <= 8 )
      {
	if (indata[1] == 2)
	{
	  b = ext_ee[0x06e9 + b];
	}
	else
	{
	  if (indata[1] < 2 && b == 0)
	    b = ext_ee[0x0736 + b];
	  else
	    b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
	}
      }
      else
      {
	b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
      }

      c = a + b - outdata[i+1];
      d = (outdata[i] - outdata[i+1]) ^ a;
      m = d * c;
      outdata[i + 2] ^= (m & 0xff);
      outdata[i + 3] += m >> 8;
      a = (a << 1) | (a >> 7);
      a += 0x49;
    }
    m = outdata[6] * outdata[7];
    a = (m & 0xff) + outdata[0];
    if (a < outdata[0]) a++;
    outdata[0] = a + 0x39;
    a = (m >> 8) + outdata[1];
    if (a < outdata[1]) a++;
    outdata[1] = a + 0x8f;
    oi = 7;
    return;
}


/************************************/
void decode ( void )
/************************************/
{
  extern unsigned char mod81;
  extern unsigned char mod83;
  extern unsigned char modaa;
  extern unsigned char mod7e;
  extern unsigned char modfe;

  unsigned char nanos[0x0f];
  unsigned char nano;
  unsigned char card_command;
  unsigned int i, j;
  unsigned int check = 0;
  unsigned char b = 0;
  unsigned char eedta, ee_offset;
  bit done;
  bit doit;
  unsigned char xx,akk,xre;
  unsigned int eepoint;

  xx = 0;


  for (i = 0; i < 8; i++) outdata[i] = 0;
  for (i = 0; i < 0x10; i++) nanos[i] = 0;
  oi = 0;

  for (i = 0; i < 0x0c; i++)
    kernel_b (indata[i]);

  xx = indata[1] ^ indata[2];
  xx = (xx>>4) | (xx<<4);
  b = indata[2];
  for (i = 0; i < 4; i++)
  {
    b = (b<<1) | (b>>7);
    nanos[i] = xx + b;
    b = nanos[i];
  }

  card_command = nanos[0] ^ indata[3];

  xx = nanos[2];
  for (i = 0; i < 0x0f; i++)
  {
    nanos[i] = xx ^ indata[i+0x0c];
    kernel_b (indata[i+0x0c]);
  }

  xx = 0;
  check = 0;
  for (i = 0x1b; i < 0x1f; i++)
  {
    kernel_b (xx);
    kernel_b (xx);
    xx = indata[i];
    if (outdata[7] != xx) check |= 1;
  }

  xx = indata[0x1f];

  if ( (card_command == 0x80) )
  {

    transmit_iso_async ( 0x60 );   /* that takes time, so send "wait" */

    xx=0;
    i=0;
    done = 0;
    do
    {
      nano = nanos[xx];
      doit = 1;
      switch ( nano )
      {
	case 0x03:
	  akk = xx;
	  xre = 0x03;
	  doit = 0;
	  done = 1;
	  break;
	case 0x09:
	  eepoint = (nanos[xx+1])*0x100 + nanos[xx+2];
	  akk = 0x63;
	  xre = 0x00;
	  xx += 3;
	  break;
	case 0x11:
	  eepoint = (nanos[xx+2]*0x100) + (nanos[xx+3]);
	  eedta = nanos[xx+1];
	  switch (eepoint)
	  {
	    case 0x81:
	      eedta &= 0xb7;
	      eedta |= 0x40;
	      mod81 = eedta;
	      break;
	   case 0xaa:
	      modaa = eedta;
              break;
           case 0xfe:
              modfe = eedta;
              break;
	    default:
	      break;
	  }
	  akk = eedta;
	  xre = 0x00;
	  xx += 4;
	  break;
	case 0x19:
	  akk = xx;
	  xre = 0x19;
	  xx += 1;
	  break;
	case 0x28:
	  akk = nanos[xx+4];
	  xre = xx;
	  xx += 5;
	  break;
	case 0x30:
	  ee_offset=nanos[xx+1];
	  do
	  {
	    eedta = ext_ee[eepoint+ee_offset];
	    if (eepoint+ee_offset == 0x81) eedta = mod81;
	    else
	    if (eepoint+ee_offset == 0x83) eedta = mod83;
	    else
	    if (eepoint+ee_offset == 0xaa) eedta = modaa;
            else
	    if (eepoint+ee_offset == 0x7e) eedta = modfe;  /* 7.4.95 */
            else
	    if (eepoint+ee_offset == 0xfe) eedta = modfe;  /* 7.4.95 */
	    kernel_b(eedta);
	  } while ( --ee_offset < 0x80 );
	  akk = eedta;
	  xre = ee_offset;
	  xx += 2;
	  break;
	case 0x39:
	  akk = nanos[xx+1];
	  xre = 0x00;
	  xx += 2;
	  break;
	case 0x46:
	  outdata[7] &= 0x7f;
  	  if ((check & 1) == 0)   return;	   /* all fine....*/
  	  for (i = 0; i < 8; i++) outdata[i] = 0;
  	  outdata[0]=1;
 	  return;
	default:
	  akk = 0x00;
	  xre = 0x00;
	  xx += 1;
	  done = 1;
          doit = 0;
	  break;
      } /* end - switch (nano) */
      if ( doit )
      {
	kernel_b(akk);
	kernel_b(xre);
      }
    } while ( (xx<=0x0f) && !done );
  } /* end - if (card_command == 0x80 ) */

  /* last iteration 64 times */
  if ( indata[0]&8 == 0 ) return;	/* speed up if no key necc. */

  for ( i = 0 ; i < 0x40 ; i++ )
    kernel_b(xx);
  outdata[7] &= 0x7F;

  /* test checksum of datastream */
  b = 0;
  for (i = 0; i < 0x20; i++) b += indata[i];
  if (b != 0) check |= 2;

  if ((check & 1) == 0)   return;		/* all fine....*/

  for (i = 0; i < 8; i++) outdata[i] = 0;       /* else prepare answer....*/
  outdata[0]=1;
  return;
}
