{$R-}
unit seascom10;

interface

uses crt,dos,number;

const COMport:Byte=2;
const inv:Boolean=true;
      wa:LongInt=25000;    { between RESET and answer }
      wbs:Longint=800;     { between each outgoing byte }
      wbr:LongInt=800;
      wc:LongInt=0;     { between $78 and new reset }
      wd:LongInt=0;     { between anser_to_reset and first header byte }
      dout:Word=0;
      dlay:Boolean=false;      { true:Delay ber int15 - false:Delay der int8 }
      timeout:LongInt=4800;
      newreset:boolean=false; { reset signalisieren }
      ende:boolean=false;     { Programmende signalisieren }
      pacereset:boolean=false;
      no_onscreen:boolean=true;
      log:boolean=false;
      logname:string='SEAPA.LOG';
      aoffset:byte=0;
      dw:Word=50;
var dummy,sta,ser_COM:Word;
    kwait:LongInt;
    tcount,callold,tmcount,wbscount,wbrcount,
    oldcount,sessioncount:LongInt;
    tast:byte;
    f:Text;

var COM_PORT_ADR:array[0..4] of Word absolute $0040:0000;
    COM_BASIS:Integer;

    OldInt8:Pointer;

function trans(b:byte):byte;
procedure pDelay(w:LongInt);
function acttime:string;
procedure OutMsg(msg:String);
procedure InitCOM;
procedure ClearUART;
function SendTo(byt:Byte):Integer;
function ReceiveFrom:Byte;
procedure WaitForReset;
procedure SetTimer(w:Word);
procedure RestoreTimer;


implementation

{ Timingroutine }
procedure pDelay(w:LongInt);
var wh,wl:Word;
    wd:LongInt;
begin
  if dlay then begin
    wh:=w shr 16;
    wl:=w and $ffff;
    asm
      mov ah,$86
      mov cx,wh
      mov dx,wl
      int $15
    end;
  end else begin
    wd:=(w*48) div 10000;
    tcount:=0;
    while tcount<=wd do ;
  end;
end;

function acttime:string;
var h,m,s,s100:Word;
    s1,s0:String;
begin
  GetTime(h,m,s,s100);
  Str(h:2,s1); Str(m:2,s0); s1:=s1+':'+s0;
  Str(s:2,s0); s1:=s1+':'+s0;
  acttime:=s1;
end;

procedure OutMsg(msg:String);
var i:byte;
begin
  { Bildschirm scrollen }
  asm
    mov ah,6; mov al,1
    mov bh,$07;
    mov ch,16; mov cl,0
    mov dh,23; mov dl,78
    int $10;
  end;
  GotoXY(1,24); Write(acttime,' ',msg);
  if log then WriteLn(f,acttime,' ',msg);
end;

{ *** reverses und invertes bytes **** }
function trans(b:byte):byte;
var inf,rev:Byte;
begin
  asm
    mov al,b
    mov ah,0
    mov cl,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    rcr al,1
    rcl ah,1
    xor ah,$ff
    mov rev,ah
  end;
  trans:=rev;
end;

procedure wait; assembler;
asm
  nop
  nop
  nop
  nop
end;

{ **** COM Initialisieren **** }
procedure InitCOM;
var dummy:Byte;
begin
  { COM Portadresse aus den BIOS Variablen }
  COM_BASIS:=COM_PORT_ADR[COMport-1];
  { 9600 bits/s einstellen }
  wait; port[COM_BASIS+3]:=port[COM_BASIS+3] or 128;
  wait; port[COM_BASIS+0]:=$0c;
  wait; port[COM_BASIS+1]:=$00;
  { 8 Datenbits, gerade Paritt, 2 Stopbits einstellen }
  wait; port[COM_BASIS+3]:=1+2+4+8;
  { keine Interrupts }
  wait; port[COM_BASIS+4]:=port[COM_BASIS+4] and $f7;
  { FIFO Puffer aus }
  wait; port[COM_BASIS+2]:=0;
end;

{ alten Daten auslesen }
procedure ClearUART;
begin
  { alten Daten auslesen }
  dummy:=$e9;
  while (port[COM_BASIS+5] and 1=0) and (dummy=$e9) do begin
  wait; dummy:=port[COM_BASIS+0]; outmsg('reset '+hex8(dummy)); end;
end;

{ Keystrikes verarbeiten }
function InterpretKey:boolean;
var erg,d:boolean;
begin
  erg:=false; d:=false;
  while keypressed do
    case readkey of
      #27:begin ende:=true; erg:=true; end;     { Programmende }
      #13:begin newreset:=true; erg:=true; end; { Reset auslsen }
      'a':begin inc(wa,dw); d:=true; end;
      'y':begin dec(wa,dw); d:=true; end;
      'x':begin dec(wbs,dw); wbr:=wbs; d:=true; end;
      's':begin inc(wbs,dw); wbr:=wbs; d:=true; end;
      'd':begin inc(wc,dw); d:=true; end;
      'c':begin dec(wc,dw); d:=true; end;
      'f':begin inc(wd,dw); d:=true; end;
      'v':begin dec(wd,dw); d:=true; end;
      ' ':begin tast:=tast+1; gotoxy(1,1); write(tast); end;
    end;
  if d then begin
  GotoXY(1,14); Write('settings      com=',comport,' wa=',wa,' wb=',wbr,
  ' wc=',wc,' int15=',dlay,' osd=',not no_onscreen);
  end;
  interpretkey:=erg;
end;

{ **** Byte vom Decoder empfangen **** }
function ReceiveFrom:Byte;
var localend,tout:boolean;
    status,receive:Byte;
begin
  if (newreset) or (ende)then exit;
  localend:=false; tout:=false;
  repeat
    tmcount:=0; status:=0;
    while status=0 do begin
      status:=status+1*Ord(port[COM_BASIS+5] and 1>0)
                    +2*Ord(tmcount>timeout)
                    +4*Ord(keypressed)
                    +8*Ord(port[COM_BASIS+6] and 128>0);
{      GotoXY(10,1); Write(status:2,tmcount:7);}
    end;
    if status and 1>0 then
          begin { alles OK }
            receive:=port[COM_BASIS+0];
            if inv then receive:=trans(receive);
            ReceiveFrom:=receive;
            localend:=true;
            pDelay(wbr);
          end;
    if status and 2>0 then
          begin { timeout }
            if not tout then begin
              outmsg('timeout: switch to an non-videocryptprogram');
              tout:=true; tmcount:=0;
            end;
          end;
    if status and 4>0 then
          begin { keypressed }
            localend:=InterpretKey;
          end;
    if status and 8>0 then
          begin { reset }
            newreset:=true;
            localend:=true;
          end;
  until (localend) or (ende);
end;

{ **** Byte zum Decoder schicken **** }
function SendTo(byt:Byte):Integer;
var ready,tout,reset,localend:boolean;
    status,status2,send,receive:Byte;
begin
  if (newreset) or (ende) then exit;
  if inv then send:=trans(byt)
         else send:=byt;
  localend:=false; status:=0;
  pDelay(wbs);
  repeat
    tmcount:=0; tout:=false;
    while status=0 do begin
      status:=status+1*Ord(port[COM_BASIS+5] and 32>0)  { Warten bis UART zum Senden bereit ist}
                    +2*Ord(tmcount>timeout)
                    +4*Ord(keypressed)
                    +8*Ord(port[COM_BASIS+6] and 128>0);
{      gotoxy(1,1); Write(status:2,tmcount:7);}
    end;
    if status and 1>0 then
          begin { alles OK }
            port[COM_BASIS+0]:=send;
            status2:=0; tmcount:=0;
{            pDelay(wbr);}
            { aufs ECHO warten }
            while status2=0 do  begin
               while (port[com_basis+5] and 1>0) do begin
                 receive:=port[com_basis];
                 if receive=send then status2:=1;
               end;
               if tmcount>timeout then status2:=2;
               if keypressed then InterpretKey;
               if ende then status2:=3;
               if port[COM_BASIS+6] and 128>0 then begin status:=8;
                 status2:=8; end;
            end;
            localend:=true;
          end;
    if status and 2>0 then
          begin
            if not tout then begin
              outmsg('timeout: switch to an non-videocryptprogram');
              tout:=true; tmcount:=0;
            end;
          end;
    if status and 4>0 then
          begin localend:=InterpretKey; end;
    if status and 8>0 then
          begin newreset:=true; localend:=true; end;
  until (localend) or (ende);
end;

procedure WaitForReset;
var status,receive:Byte;
begin
  status:=0;
  while status=0 do begin
    if port[COM_BASIS+6] and 128>0 then status:=1;
    if keypressed then InterpretKey;
    if ende then status:=4;
  end;
  if status=1 then
    while port[com_basis+6] and 128>0 do
      receive:=port[com_basis];
end;

{ **** New Int8 Timer **** }
procedure NewInt8; interrupt;
begin
  asm cli end;
  inc (tcount);
  inc (oldcount);
  inc (sessioncount);
  asm sti end;
  port[$20]:=$20;
  if (callold<>0) and (oldcount>=callold) then begin
    inline($9c/$ff/$1e/oldint8); { damit die DOS Uhr richtig tickt ;-) }
    oldcount:=0;
  end;
end;

procedure SetTimer(w:Word);
begin
  asm cli end;
  GetintVec($08,OldInt8);
  SetIntVec($08,@NewInt8);
  if w<>0 then callold:=(65536) div w
          else callold:=0;
  port[$40]:=Lo(w);
  asm nop                  { wait, because my 586 is too fast :-( }
  nop                      { if you have timing problems, try it  }
  nop                      { without the nop's                    }
  nop end;
  port[$40]:=Hi(w);;
  asm sti end;
  tcount:=0;
  wbscount:=0;
  wbrcount:=0;
  oldcount:=0;
  sessioncount:=0;
end;

procedure RestoreTimer;
begin
  asm cli end;    { bitte nicht stren }
  SetIntVec($08,OldInt8);
  port[$40]:=0;
  asm nop
  nop
  nop
  nop
  end;
  port[$40]:=0;
  asm sti end;
end;


begin
tast:=1;
end.