/*
 * This module contains the critical algorithm and secret key
 * used by British Sky Broadcasting in their Videocrypt pay-TV
 * chip card in 1994 and 1995. It is expected that most
 * information in this file becomes obsolete when the next card
 * generation (0a) is activated.
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ctype.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <bios.h>
#include <string.h>
#include <time.h>

#include "decrypt.h"
#include "rompages.h"
#include "protypes.h"

/***********************************************************************
*                                                                      *
*      external definitions                                            *
*                                                                      *
***********************************************************************/
extern unsigned char indata[];      // input, 32-byte message
extern unsigned char outdata[];     // output, answer to 32-byte message
extern debugnano;
extern packet_counter;
extern test_offset;

/***********************************************************************
*                                                                      *
*      workfields                                                      *
*                                                                      *
***********************************************************************/
/*
 * the secret key -- for your eyes only :-)     07-series
 */
/*
const unsigned char key[56] = {
  0x65, 0xe7, 0x71, 0x1a, 0xb4, 0x88, 0xd7, 0x76,
  0x28, 0xd0, 0x4c, 0x6e, 0x86, 0x8c, 0xc8, 0x43,
  0xa9, 0xec, 0x60, 0x42, 0x05, 0xf2, 0x3d, 0x1c,
  0x6c, 0xbc, 0xaf, 0xc3, 0x2b, 0xb5, 0xdc, 0x90,
  0xf9, 0x05, 0xea, 0x51, 0x46, 0x9d, 0xe2, 0x60,
  0x70, 0x52, 0x67, 0x26, 0x61, 0x49, 0x42, 0x09,
  0x50, 0x99, 0x90, 0xa2, 0x36, 0x0e, 0xfd, 0x39
};
*/
// Eurotica and the Adult Channel:
const unsigned char key[56] = {
  0x48,  0x9b,  0x4d,  0xa6,  0xf9,  0xd9,  0xdf,  0x6e,  0xac,
  0x84,  0xfa,  0x8b,  0x2e,  0xb6,  0x76,  0x19,  0xc1,  0xb0,
  0xa3,  0xbb,  0x0c,  0xfd,  0x70,  0x72,  0xca,  0x55,  0xef,
  0xa0,  0x7f,  0xbf,  0x59,  0xad,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00};


unsigned char oi;
extern char screenbuf[];
unsigned char tempstr[50];
unsigned char nanoheader[10];
unsigned char *nanodata;
unsigned char nanolength[0x100] = {
/* 00-0f */  4, 4, 4, 1, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 2,
/* 10-1f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4,
/* 20-2f */  4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4,
/* 30-3f */  2, 4, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 4, 4,
/* 40-4f */  4, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* 50-5f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* 60-6f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* 70-7f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* 80-8f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* 90-9f */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* a0-af */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* b0-bf */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* c0-cf */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* d0-df */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* e0-ef */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
/* f0-ff */  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
             };

/***********************************************************************
*                                                                      *
*      03  decode_09                   parent = 01  main               *
*                                                                      *
*      rewritten for greater readability and faster execution          *
*                                                                      *
***********************************************************************/
int decode_09 ( void )
{
unsigned char nanos[0x0f];
unsigned char nano;
unsigned char card_command;
unsigned int i;
unsigned int check = 0;
unsigned int rom_page = 1;
unsigned char b = 0;
unsigned char ee_dta, ee_offset;
int done;
unsigned char xx;
unsigned int ee_point, ee_ptr;

ee_point=0;
ee_offset=0;
xx = 0;
rom_page = 1;

for (i = 0; i < 8; i++) outdata[i] = 0;
for (i = 0; i < 0x10; i++) nanos[i] = 0;
oi = 0;

for (i = 0; i < 0x0c; i++) kernel_09 (indata[i]);

xx = indata[1] ^ indata[2];
xx = (xx>>4) | (xx<<4);
b = indata[2];

for (i = 0; i < 4; i++)
  {
  b = (b<<1) | (b>>7);
  nanos[i] = xx + b;
  b = nanos[i];
  }

card_command = nanos[0] ^ indata[3];

xx = nanos[2];
for (i = 0; i < 0x0f; i++)
  {
  nanos[i] = xx ^ indata[i+0x0c];
  kernel_09 (indata[i+0x0c]);
  }

// check the signature
xx = 0;
check = 0;
for (i = 0; i < 4; i++)        // signature  
  {
  kernel_09 (xx);
  kernel_09 (xx);
  xx = indata[i+0x1b];
  if (outdata[7] != xx) check |= 1;
  }

xx = indata[0x1f];

if (card_command == 0x80)
  {
  xx = 0;
  done = 0;
  do                           // process nano commands and subcommands
    {
    nano = nanos[xx];

    // debug purpose
    nanoheader[0] = nano;
    nanoheader[1] = 0;
    nanoheader[2] = nanolength[nano];
    nanodata = nanos + xx;

    switch ( nano )
      {
      case 0x03:
        FastPrintf(21,60, 4,"03 ");        
        done = 1;
        break;
        
      case 0x09:                          // 'set pointer' command
        FastPrintf(21,60, 4,"09 ");        
        ee_point = (nanos[xx+1])*0x100 + nanos[xx+2];
        kernel_09 (0x63);
        kernel_09 (0);
        xx += 3;
        break;
        
      case 0x0f:                          // 1.8.95
        FastPrintf(21,60, 4,"0f ");        
        ee_ptr = (ext_ee[0xbf]*0x100) + (ext_ee[0xc0]);
        ee_ptr &= 0x1fff;
        ext_ee[ee_ptr] = nanos[xx+1];
        // ext_ee[0xaa] = nanos[xx+1];
        done = 1;
        break;

      case 0x11:                               // 'move value into
        FastPrintf(21,60, 4,"11 ");            // cardmem' command
        ee_point = (nanos[xx+2]*0x100) + (nanos[xx+3]);

        nanoheader[1] = ee_point;              // debug purpose

        ee_dta = nanos[xx+1];
        switch (ee_point)
          {
          case 0x08:                           // 17.5.95
            FastPrintf(21,63, 4,"08 ");            
            ext_ee[0x08] = ee_dta;
            if (ee_dta == 0xc0) rom_page = 2;
            if (ee_dta == 0x40) rom_page = 1;
            ee_dta &= 0xb7;
            ee_dta |= 0x40;
            ext_ee[0x81] = ee_dta;
            break;

          case 0x81:
            FastPrintf(21,63, 4,"81 ");            
            ee_dta &= 0xb7;
            ee_dta |= 0x40;
            ext_ee[0x81] = ee_dta;
            break;

          case 0xee:                   // 15.8.95
            ext_ee[0xee] = ee_dta;
            xx += 2;
            break;

          default:
            sprintf(screenbuf,"%02x ",ee_point);            
            FastPrintf(21,63, 4,screenbuf);
            if (ee_point >= 0xaa) ext_ee[ee_point] = ee_dta;
            break;
          } /* end switch ee_point */
        
        kernel_09 (ee_dta);
        kernel_09 (0);
        xx += 4;
        break;

      case 0x19:
        FastPrintf(21,60, 4,"19 ");        
        kernel_09 (xx);
        kernel_09 (0x19);
        xx++;
        break;
        
      case 0x28:
        FastPrintf(21,60, 4,"28 ");        
        kernel_09 (nanos[xx+4]);
        kernel_09 (xx);
        xx += 5;
        break;

      case 0x30:
        // uses previously set pointer ee_point
        FastPrintf(21,60, 4,"30 ");        
        ee_offset = nanos[xx+1];
        do
          {
          ee_ptr = ee_point + ee_offset;
          if (ee_ptr == 0x7e) ee_ptr |= 0x80;              // 7.4.95
          
          if (rom_page == 1) ee_dta = ext_ee[ee_ptr];      // 17.5.95
                        else ee_dta = ext_ee2[ee_ptr];

          kernel_09(ee_dta);
          } while ( --ee_offset < 0x80 );  // this is the vampire hack i think
        
        kernel_09 (ee_dta);
        kernel_09 (ee_offset);
        xx += 2;
        break;

      case 0x39:
        FastPrintf(21,60, 4,"39 ");        
        kernel_09 (nanos[xx+1]);
        kernel_09 (0);
        xx += 2;
        break;

      case 0x46:                                 // this is the break command
        FastPrintf(21,60, 4,"46 ");        
        outdata[7] &= 0x7f;
        if (debugnano) log_nano(nanoheader, nanodata, 
                                indata[0] & 8, packet_counter);
        if ((check & 1) == 0)   return check;    // all fine ...
        for (i = 0; i < 8; i++) outdata[i] = 0;  // indicate error ...
        outdata[0] = 1;
        return check;

      default:
        sprintf(screenbuf,"%02x ",nano);        
        FastPrintf(21,60, 4,screenbuf);
        xx++;
        done = 1;
        break;
      
      } /* end - switch (nano) */
    
    if (debugnano) log_nano(nanoheader, nanodata, 
                            indata[0] & 8, packet_counter);
    
    } while ( (xx<=0x0f) && !done ); /* end do while */
  
  } /* end - if (card_command == 0x80 ) */
  
// last iteration 64 times
if ( indata[0] & 8 == 0 ) return check;    // speed up if no key necc.

for ( i = 0 ; i < 0x40 ; i++ ) kernel_09(xx);
outdata[7] &= 0x7f;            // only 60 bits in answer needed, blank out
                               // last nibble

// test checksum of datastream
b = 0;
for (i = 0; i < 0x20; i++) b += indata[i];
if (b != 0) check |= 2;

if ((check & 1) == 0)   return check;      // all fine ...

for (i = 0; i < 8; i++) outdata[i] = 0;    // else prepare answer ...
outdata[0]=1;

return check;
}

/***********************************************************************
*                                                                      *
*      05  kernel_09                   parent = 03  decode_09          *
*                                                                      *
*                                                                      *
*      This is the core function of the decryption algorithm           *
*      which is iterated 99 times by decode(). This code assumes that  *
*      unsigned char is exactly 8-bit long.                            *
*                                                                      *
***********************************************************************/
void kernel_09( unsigned char in )
{
unsigned char a, b, c, d, i;
unsigned int m;


if ( indata[0] & 8 == 0 ) return;      // speed up

a = in;
for (i = 0; i <= 4; i += 2)
  {
  b = outdata[i] & 0x3f;
  if (indata[0] <= 8 )
    {
    if (indata[0] == 2)
      {
      b = ext_ee[0x06e9 + b];
      }
     else
      {
      if (indata[0] < 2 && b == 0) 
        b = ext_ee[0x0736 + b];
       else
        b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
      }
    }
   else
    {
    b =  ext_ee[0x6a9 + b] ^ ext_ee[0x0741 + b];
    }

  c = a + b - outdata[i+1];
  d = (outdata[i] - outdata[i+1]) ^ a;
  m = d * c;
  ext_ee[0xe7] = m >> 8;       // 15.6.95
  outdata[i + 2] ^= (m & 0xff);
  outdata[i + 3] += m >> 8;
  a = (a << 1) | (a >> 7);
  a += 0x49;
  } /* end for i */

m = outdata[6] * outdata[7];
a = (m & 0xff) + outdata[0];
if (a < outdata[0]) a++;
outdata[0] = a + 0x39;
a = (m >> 8) + outdata[1];
if (a < outdata[1]) a++;
outdata[1] = a + 0x8f;
oi = 7;

return;
}



/***********************************************************************
*                                                                      *
*      03  decode_07                   parent = 01  main               *
*                                                                      *
***********************************************************************/
/*
 * The decoder requests every ~2.5 seconds an answer to a 32-byte
 * packet (msg) from the chip card. The card's 8-byte answer (answ) to
 * this request is calculated by this function.
 */
int decode_07(const unsigned char *msg, unsigned char *answ, int offset)
{
int i;
int oi = 0;           /* index in output array answ[] */
// int offset = 0;       /* secret key table selection   */
int check = 0;        /* flag for incorrect checksum  */
unsigned char b = 0;

// if (msg[1] > 0x32) offset = 0x08;
// if (msg[1] > 0x3a) offset = 0x18;

for (i = 0; i < 8; i++) answ[i] = 0;
for (i = 0; i < 27; i++)
  kernel_07(answ, &oi, msg[i], offset);
for (i = 27; i < 31; i++) 
  {
  kernel_07(answ, &oi, b, offset);
  kernel_07(answ, &oi, b, offset);
  b = msg[i];
  if (answ[oi] != msg[i]) check |= 1;
  oi = (oi + 1) & 7;
  }

// msg[30] is completely ignored
for (i = 0; i < 64; i++)
  if (msg[3] < 2)
    kernel_07(answ, &oi,  msg[31], offset);
   else
    kernel_07(answ, &oi, /* msg[31] */ 0x0d /* 25.05.95 */ , offset);

// test checksum
b = 0;
for (i = 0; i < 32; i++) b += msg[i];
if (b != 0) check |= 2;

answ[7] &= 0x0f;

return check;
}

/***********************************************************************
*                                                                      *
*      05  kernel_07                   parent = 03  decode_07          *
*                                                                      *
*                                                                      *
*      This is the core function of the decryption algorithm           *
*      which is iterated 99 times by decode(). This code assumes that  *
*      unsigned char is exactly 8-bit long.                            *
*                                                                      *
***********************************************************************/
void kernel_07(unsigned char *out, int *oi, const unsigned char in,
               int offset)
{
unsigned char b, c;

out[*oi] ^= in;
b = key[offset + (out[*oi] >> 4)];
c = key[offset + (out[*oi] & 0x0f) + 16];
c = ~(c + b);
c = (c << 1) | (c >> 7);    /* rotate 1 left */
c += in;
c = (c << 1) | (c >> 7);    /* rotate 1 left */
c = (c >> 4) | (c << 4);    /* swap nibbles */
*oi = (*oi + 1) & 7;
out[*oi] ^= c;

return;
}


